/* July 24th, 2005

  Copyright (C) 2005 -  Riccardo Scarsi

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Riccardo Scarsi scarsi@tiscalinet.it

*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;


namespace Sudoku
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		
		private const int STARTX = 10;
		private const int STARTY = 10;
		private int cellsize = 40;
		private int actx=0, acty=0;
		private System.Windows.Forms.Button button1;
		private int[,] val = new int[9,9];
		private int[,,] valdisp = new int[9,9,10];
		private int[,] valorig = new int[9,9];
		private Thread oThread;
		private System.Windows.Forms.CheckBox checkBox1;
		private System.Windows.Forms.Label label1;

		private int fontsize = 16;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.checkBox1 = new System.Windows.Forms.CheckBox();
			this.label1 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.button1.Location = new System.Drawing.Point(8, 400);
			this.button1.Name = "button1";
			this.button1.TabIndex = 0;
			this.button1.TabStop = false;
			this.button1.Text = "Solve";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// checkBox1
			// 
			this.checkBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.checkBox1.Location = new System.Drawing.Point(8, 376);
			this.checkBox1.Name = "checkBox1";
			this.checkBox1.TabIndex = 1;
			this.checkBox1.Text = "SlowMotion";
			// 
			// label1
			// 
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 18F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(120, 384);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(168, 32);
			this.label1.TabIndex = 2;
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(456, 430);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.checkBox1);
			this.Controls.Add(this.button1);
			this.KeyPreview = true;
			this.Name = "Form1";
			this.Text = "Form1";
			this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.Form1_KeyDown);
			this.Resize += new System.EventHandler(this.Form1_Resize);
			this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.Form1_MouseDown);
			this.Click += new System.EventHandler(this.Form1_Click);
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.Form1_KeyPress);
			this.Load += new System.EventHandler(this.Form1_Load);
			this.Paint += new System.Windows.Forms.PaintEventHandler(this.Form1_Paint);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}
		private void RefreshVals()
		{
			for(int i=0;i<9;i++)
				for(int j=0;j<9;j++)
				{
					if(val[i,j] == valorig[i,j])
						WriteCell(val[i,j],i,j,Color.Blue);
					else
						WriteCell(val[i,j],i,j,Color.Black);
				}
		}
		
		protected override bool ProcessDialogKey(Keys keyData)
		{
			switch(keyData)
			{
				case Keys.Up:
					SelectCell(actx, acty-1);
					return true;
				case Keys.Down:
					SelectCell(actx, acty+1);
					return true;
				case Keys.Left:
					SelectCell(actx-1, acty);
					return true;
				case Keys.Right:
					SelectCell(actx+1, acty);
					return true;
				case Keys.Space:
					WriteCell(0,actx,acty,Color.Blue);
					val[actx,acty]=valorig[actx,acty] = 0;
					return true;
			}
			return false;
		
		}

		private void SelectCell(int x, int y)
		{
			if(x<0 || x>8)
				x=actx;
			if(y<0 || y>8)
				y=acty;

			Graphics g = CreateGraphics();
			Pen pen = new Pen(Color.Black);

			pen.Color = (acty%3)==0?Color.Red:Color.Black;
			g.DrawLine(pen,STARTX + actx * cellsize, STARTY + acty * cellsize, STARTX + (actx+1) * cellsize, STARTY + acty * cellsize);  
			pen.Color = (actx%3)==0?Color.Red:Color.Black;
			g.DrawLine(pen,STARTX + actx * cellsize, STARTY + acty * cellsize, STARTX + actx * cellsize, STARTY + (acty+1) * cellsize);  
			pen.Color = ((actx+1)%3)==0?Color.Red:Color.Black;			
			g.DrawLine(pen,STARTX + (actx+1) * cellsize, STARTY + acty * cellsize, STARTX + (actx+1) * cellsize, STARTY + (acty+1) * cellsize);  
			pen.Color = ((acty+1)%3)==0?Color.Red:Color.Black;
			g.DrawLine(pen,STARTX + actx * cellsize, STARTY + (acty+1) * cellsize, STARTX + (actx+1) * cellsize, STARTY + (acty+1) * cellsize);  

			actx = x;
			acty = y;
			
			pen.Color = Color.Yellow;
			g.DrawLine(pen,STARTX + actx * cellsize, STARTY + acty * cellsize, STARTX + (actx+1) * cellsize, STARTY + acty * cellsize);  
			g.DrawLine(pen,STARTX + actx * cellsize, STARTY + acty * cellsize, STARTX + actx * cellsize, STARTY + (acty+1) * cellsize);  
			g.DrawLine(pen,STARTX + (actx+1) * cellsize, STARTY + acty * cellsize, STARTX + (actx+1) * cellsize, STARTY + (acty+1) * cellsize);  
			g.DrawLine(pen,STARTX + actx * cellsize, STARTY + (acty+1) * cellsize, STARTX + (actx+1) * cellsize, STARTY + (acty+1) * cellsize);  
			
			pen.Dispose();
			g.Dispose();
		}
		private void Form1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			for(int i = 0;i<10;i++)
			{
				Pen pen;
				if(i % 3 == 0)
					pen = new Pen(Color.Red);
				else
					pen = new Pen(Color.Black);

				e.Graphics.DrawLine(pen, STARTX + i * cellsize, STARTY, STARTX + i * cellsize, STARTY + 9 * cellsize);
				e.Graphics.DrawLine(pen, STARTX, STARTY + i * cellsize, STARTX + 9 * cellsize, STARTY + i * cellsize);
				pen.Dispose();
			}
			SelectCell(actx, acty);
			RefreshVals();
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			Form1_Resize(sender, e);
		}

		private void Form1_Click(object sender, System.EventArgs e)
		{
		
		}

		
		private void Form1_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			SelectCell((e.X - STARTX) / cellsize, (e.Y - STARTY) / cellsize);
		}

		private void WriteCell(int v, int x, int y, Color cl)
		{
			string str;

			Graphics g = CreateGraphics();
			Pen pen = new Pen(Color.Black);

			Font drawFont = new System.Drawing.Font("Arial", fontsize);
			SolidBrush drawBrush = new System.Drawing.SolidBrush(BackColor);
			StringFormat drawFormat = new System.Drawing.StringFormat();
			Rectangle rect = new Rectangle(STARTX + x * cellsize+1, STARTY + y * cellsize+1, cellsize-1, cellsize-1);
			g.Clip = new Region(rect);
			g.FillRectangle(drawBrush, rect);
			drawBrush.Color = cl;
			if(v<=0||v>9)
				str=" ";
			else
				str = v.ToString();
			
			//			g.DrawString( str, drawFont, drawBrush, STARTX + x * cellsize, STARTY + y * cellsize, drawFormat);
			drawFormat.Alignment = System.Drawing.StringAlignment.Center;
			drawFormat.LineAlignment = System.Drawing.StringAlignment.Center;
			g.DrawString( str, drawFont, drawBrush, rect, drawFormat);
			
			drawFont.Dispose();
			drawBrush.Dispose();


			pen.Dispose();
			g.Dispose();
		}
		private void Form1_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if(e.KeyChar == '\r')
			{
				button1_Click(sender, e);
				e.Handled=true;
				return;
			}
			if(!Char.IsNumber(e.KeyChar)&&e.KeyChar!=' ')
			{
				return;
			}
			if(actx != -1 && acty != -1)
			{
				if(e.KeyChar==' ')
				{
					WriteCell(0,actx,acty,Color.Blue);
					val[actx,acty]=valorig[actx,acty] = 0;
				}
				else
				{
					WriteCell(e.KeyChar - '0',actx,acty,Color.Blue);
					val[actx,acty]=valorig[actx,acty] = e.KeyChar - '0';
				}
				e.Handled = true;
			}
		}

		private void Form1_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			switch(e.KeyCode)
			{
				case Keys.Up:
					SelectCell(actx, acty-1);
					break;
				case Keys.Down:
					SelectCell(actx, acty+1);
					break;
				case Keys.Left:
					SelectCell(actx-1, acty);
					break;
				case Keys.Right:
					SelectCell(actx+1, acty);
					break;
			}
		}

		private bool CercaVuota(out int x, out int y)
		{

			for(x=0,y=0;x<9;x++)
				for(y=0;y<9;y++)
					if(val[x,y]==0)
						return true;
			return false;
		}

		private bool CercaVuotaDisp(out int x, out int y)
		{
			int min=10,minx=0,miny=0;

			for(x=0,y=0;x<9;x++)
				for(y=0;y<9;y++)
					if(val[x,y]==0 && min>valdisp[x,y,0])
					{
						min = valdisp[x,y,0];
						minx=x; miny=y;
					}
			if(min != 10)
			{
				x=minx;
				y=miny;
				return true;
			}
			return false;
		}

		private bool Compatibile(int v, int x, int y)
		{
			int i,j;

			//Controllo che sulla riga e sulla colonna non ci sia gi lo stesso numero
			for(i=0;i<9;i++)
			{
				if (val[x,i] == v && i != y) 
					return false;
				
				if (val[i,y]==v && i !=x)
					return false;
			}
			//Controllo che nel riquadro non ci sia gi lo stesso numero
			for(i=0;i<3;i++)
				for(j=0;j<3;j++)
				{
					if(i==x&&j==y)
						continue;
					if(val[x/3*3+i,y/3*3+j]==v)
						return false;
				}
			//Controllo 

			return true;

		}
		private bool SolveSudoku()
		{
			int vx,vy;

			if(!CercaVuota(out vx, out vy))
				return true;
			for(int i=1;i<10;i++)
			{
				if(Compatibile(i,vx,vy))
				{
					val[vx,vy]=i;
					if (SolveSudoku())
						return true;
					val[vx,vy]=0;
				}
			}
			return false;
		}
		private void SolveSudokuDispStart()
		{
			val = (int[,])valorig.Clone();
			// Verifica che sia risolvibile...
				

			for(int i = 0;i<9 ; i++)
				for(int j = 0;j<9;j++)
				{
					valdisp[i,j,0]=0;
					for(int v=1;v<10;v++)
					{
						if(val[i,j]!=0)
							valdisp[i,j,v] = 0;
						else if(Compatibile(v,i,j))
						{
							valdisp[i,j,v] = 1;
							valdisp[i,j,0] ++;
						}
						else
							valdisp[i,j,v] = 0;
					}
				}

			for(int i = 0;i<9 ; i++)
				for(int j = 0;j<9;j++)
				{
					if(val[i,j]!=0)
					{
						int v=val[i,j];
						val[i,j] = 0 ;
						if(!Compatibile(v,i,j))
						{
							label1.Text = "Not solvable...";
							label1.ForeColor = Color.Red;	
							val[i,j] = v;
							return;
						}
						val[i,j] = v;
					}
				}

			if(SolveSudokuDisp())
			{
				label1.Text = "Solved";
				label1.ForeColor = Color.Green;
			}
			else
			{
				label1.Text = "No solution";
				label1.ForeColor = Color.Red;
			}
			RefreshVals();
		}
		private bool SolveSudokuDisp()
		{
			int vx,vy;
			int[] xdisp = new int[9], ydisp= new int[9];
			int [,] qdisp= new int[3,3];

			if(!CercaVuotaDisp(out vx, out vy))
				return true;
			for(int v=1;v<10;v++)
			{
				if(valdisp[vx,vy,v]==1)
				{
					for(int i=0;i<9;i++)
					{
						xdisp[i] = valdisp[i,vy,v];
						ydisp[i] = valdisp[vx,i,v];
					}
					for(int i=0;i<3;i++)
						for(int j=0;j<3;j++)
						{
							qdisp[i,j] = valdisp[vx/3*3+i, vy/3*3+j, v];
							if( valdisp[vx/3*3+i, vy/3*3+j, v] != 0)
							{
								valdisp[vx/3*3+i, vy/3*3+j, v] = 0;
								valdisp[vx/3*3+i, vy/3*3+j, 0] --;
							}
						}
					for(int i=0;i<9;i++)
					{
						if(valdisp[i,vy,v]!=0)
						{
							valdisp[i,vy,v] = 0;
							valdisp[i,vy,0] --;
						}

						if(valdisp[vx,i,v] != 0)
						{
							valdisp[vx,i,v] = 0;
							valdisp[vx,i,0] --;
						}
					}

					val[vx,vy]=v;
					if(checkBox1.Checked==true)
						Thread.Sleep(100);
					WriteCell(v, vx, vy, Color.BlueViolet);
					if (SolveSudokuDisp())
						return true;
					val[vx,vy]=0;
					WriteCell(0, vx, vy, Color.BlueViolet);
					for(int i=0;i<9;i++)
					{
						if(valdisp[i,vy,v] != xdisp[i])
						{
							valdisp[i,vy,v] = xdisp[i];
							valdisp[i,vy,0]++;
						}
						if(valdisp[vx,i,v] != ydisp[i])
						{
							valdisp[vx,i,v] = ydisp[i];
							valdisp[vx,i,0]++;
						}
					}
					for(int i=0;i<3;i++)
						for(int j=0;j<3;j++)
						{
							if(valdisp[vx/3*3+i, vy/3*3+j, v] != qdisp[i,j])
							{
								valdisp[vx/3*3+i, vy/3*3+j, v] = qdisp[i,j];
								valdisp[vx/3*3+i, vy/3*3+j, 0]++;
							}
						}

				}
			}
			return false;
		}
		private void button1_Click(object sender, System.EventArgs e)
		{
//			SolveSudoku();
			oThread = new Thread(new ThreadStart(SolveSudokuDispStart));
			oThread.Start();

//			SolveSudokuDisp();
			RefreshVals();
		}

		private void Form1_Resize(object sender, System.EventArgs e)
		{
			int min;
			if( ClientSize.Width - 2 * STARTX < ClientSize.Height - 2 * STARTY - 100)
				min = ClientSize.Width - 2 * STARTX;
			else
				min= ClientSize.Height - 2 * STARTY - 100;

			cellsize = min / 9;
			
			Graphics g = CreateGraphics();
			Pen pen = new Pen(Color.Black);
			SizeF szf;
			fontsize = 72;
			Font drawFont = new System.Drawing.Font("Arial", fontsize);
			do
			{
				fontsize -=2;
				drawFont.Dispose();
				drawFont =  new System.Drawing.Font("Arial", fontsize);
				szf = g.MeasureString("8",drawFont);
			}
			while(szf.Height > cellsize && fontsize >4);

			pen.Dispose();
			drawFont.Dispose();
			g.Dispose();
			Refresh();
		}

		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if(oThread != null)
                oThread.Abort();
		}
	}
}
